<?php
session_start();
if(!isset($_SESSION['loggedin'])){
    header("Location:login.php");
    return;
}
try {
    $file = './settings.json';
    if(file_exists($file)){
        $data = file_get_contents($file);
        $json_data = json_decode($data, true);
        if( isset( $json_data['showAdvertisment'] ) ){
            $showAdvertisment=$json_data["showAdvertisment"];
         }else{
            $showAdvertisment=false;
         }
         if( isset( $json_data['advertismentImage'] ) ){
            $advertismentImage=$json_data["advertismentImage"];
         }else{
            $advertismentImage=false;
         }
       
    }else{
        $_SESSION["error"]=" internal error , please try again later or contact support";
        header("Location:login.php");
        return;
    }
}catch(Exception $e){
    $_SESSION["error"]=" internal error , please try again later or contact support";
    header("Location:login.php");
    return;
}

?>
<!DOCTYPE html>
<html>
   <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
        <link href="dashboard.css" rel="stylesheet">
        <title>Dashboard </title>
   </head>

<body>

    <div class="container">
        <br>
        <div class="row justify-content-center">
            <img src="./assets/imgs/logo_new.png" alt="Logo" style="max-height:200px;max-width:75%;">
            
        </div>
        <div class="card">
            <div class="card-header bg-light">
              Settings
            </div>
            <div class="card-body">
            <?php
                if(isset($_SESSION['error'])){
                    
                    echo '<div class="alert alert-danger" role="alert">';
                    echo $_SESSION['error'];
                    echo '</div>';
                    unset($_SESSION['error']);
                }
                
            ?>

            <?php
                if(isset($_SESSION['success'])){
                    
                    echo '<div class="alert alert-success" role="alert">';
                    echo $_SESSION['success'];
                    echo '</div>';
                    unset($_SESSION['success']);
                }
                
            ?>
                <div class="row">
                    <div class="col-sm-6" style="padding:10px">
                        <div class="form-group">
                           <div class="checkbox">

                           

                            <?php
                                if($advertismentImage===false){
                                    echo '<input type="checkbox"  name="showSettings" id="showSettings" onclick="changeSettings()" disabled>';
                                }else{
                                    if($showAdvertisment===true){
                                        echo '<input type="checkbox" name="showSettings" id="showSettings" onclick="changeSettings()" checked>';
                                    }else{
                                        echo '<input type="checkbox"  name="showSettings" id="showSettings" onclick="changeSettings()" >';
                                    }
                                }
                            ?>
                                
                                <label for="showSettings" style="padding-left:20px">Show Advertisement 
                                    <?php
                                    if($showAdvertisment===true){
                                        echo "Enabled";
                                    }else{
                                        echo "Disabled";
                                    }
                                    ?>
                                </label>
                                <?php if($advertismentImage===false) echo '<p class="text-danger"> No image choosen yet ! </p>' ?>
                            </div>

                        </div>                            
                        <br>
                        
                        <form class="form-inline" method="POST" action="changeimg.php" enctype="multipart/form-data">
                            <input type="file" id="advertisment-file" name="advertisment-file" accept="image/*">
                            <button type="submit" name="submit" class="btn btn-secondary">Save</button>
                        </form>
                    </div>
                    <div class="col-sm-6"  >
                        <div class="row justify-content-center " style="padding:20px">
                        <?php
                         if($advertismentImage===false){
                            echo ' <img src="imgs/no_image.png" alt="advertisment image" style="max-height:250px"> ';
                         }else{
                            echo ' <img src="imgs/'.$advertismentImage .'" alt="advertisment image" style="max-height:250px"> ';

                         }
                        
                        ?>
                           
                        </div>
                        
                    </div>
                </div>
                
            </div>
        </div>
       
    </div>

    <script>
    function changeSettings() {
        console.log("Jol;ks");
        var checkBox = document.getElementById("showSettings");
        if (checkBox.checked == true){
            window.location.href = "changeshow.php?show=1";
        } else {
            window.location.href ="changeshow.php?show=0";       }
    }

    </script>
  
        <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>

</body>

</html>